__extensions [ "sound.jar" ]

globals [ instrument-index memory ]

;; initializes the instrument-index and the memory bank
to startup
  set instrument-index 0
  set memory (list "" "" "" "")
end

;; plays the current note and prints it to the command center
to play
  run generate-command
  print generate-command
end

;; generates a NetLogo command to play the current instrument
;; at the current pitch with the current velocity
to-report generate-command
  report "play-note \"" + ( item instrument-index instruments ) 
  + "\" " + pitch + " " + velocity + " " + duration
end

;; saves the current command in the nth memory slot
to save [ n ]
  set memory replace-item n memory generate-command
end

;; returns a list of pitches comprising a middle-C major scale
to-report c-major-scale
  report map [? + 60] [0 2 4 5 7 9 11 12]
end

;; arrow keys to scroll through the instrument list
to first-instrument 
  set instrument-index 0
  play
end

to last-instrument
  set instrument-index length instruments - 1
  play
end

to next-instrument
  if instrument-index < length instruments - 1 [
    set instrument-index instrument-index + 1
    play
  ]
end

to prev-instrument
  if instrument-index > 0 [
    set instrument-index instrument-index - 1
    play
  ]
end


; (C) 2004 Uri Wilensky.  This code may be freely copied, distributed,
; altered, or otherwise used by anyone for any purpose.
; 
; THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
; "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
; LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
; A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT
; OWNERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
; SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
; LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
; DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
; THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
; (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
; OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
@#$#@#$#@
GRAPHICS-WINDOW
455
10
639
215
1
1
58.0
1
10
1
1
1
0

CC-WINDOW
5
480
759
575
Command Center

MONITOR
144
16
311
65
instrument
(instrument-index + 1) + ". " + \n(item instrument-index instruments)
3
1

BUTTON
79
32
134
65
<--
prev-instrument
NIL
1
T
OBSERVER
T
NIL

BUTTON
317
32
372
65
-->
next-instrument
NIL
1
T
OBSERVER
T
NIL

SLIDER
21
103
173
136
velocity
velocity
0
127
91
1
1
NIL

SLIDER
21
173
172
206
pitch
pitch
0
120
67
1
1
NIL

BUTTON
181
158
274
191
Play note
Play
NIL
1
T
OBSERVER
NIL
NIL

SLIDER
21
137
173
170
duration
duration
0
2
0.35
0.05
1
NIL

BUTTON
21
32
76
65
|<--
first-instrument
NIL
1
T
OBSERVER
T
NIL

BUTTON
376
32
431
65
-->|
last-instrument
NIL
1
T
OBSERVER
T
NIL

BUTTON
10
313
66
361
NIL
Save 1
NIL
1
T
OBSERVER
T
NIL

MONITOR
138
309
463
358
NIL
item 1 memory
3
1

BUTTON
12
367
67
412
NIL
Save 2
NIL
1
T
OBSERVER
T
NIL

MONITOR
139
364
463
413
NIL
item 2 memory
3
1

BUTTON
466
310
521
358
Play
run item 1 memory
NIL
1
T
OBSERVER
T
NIL

BUTTON
525
311
580
359
Print
print item 1 memory
NIL
1
T
OBSERVER
T
NIL

BUTTON
71
313
126
361
Clear
set memory replace-item 1 memory ""
NIL
1
T
OBSERVER
T
NIL

BUTTON
466
364
522
412
Play
run item 2 memory
NIL
1
T
OBSERVER
T
NIL

BUTTON
525
364
580
410
Print
print item 2 memory
NIL
1
T
OBSERVER
T
NIL

BUTTON
71
366
127
412
Clear
set memory replace-item 2 memory ""
NIL
1
T
OBSERVER
T
NIL

TEXTBOX
9
288
99
306
MEMORY BANK

BUTTON
12
418
67
463
NIL
Save 3
NIL
1
T
OBSERVER
T
NIL

MONITOR
138
417
462
466
NIL
item 3 memory
3
1

BUTTON
466
418
521
463
Play
run item 3 memory
NIL
1
T
OBSERVER
T
NIL

BUTTON
525
416
580
462
Print
print item 3 memory
NIL
1
T
OBSERVER
T
NIL

BUTTON
71
418
126
463
Clear
set memory replace-item 3 memory ""
NIL
1
T
OBSERVER
T
NIL

BUTTON
461
273
534
306
Play all
foreach memory [ run ? ]
NIL
1
T
OBSERVER
T
NIL

BUTTON
553
226
644
264
NIL
stop-music
NIL
1
T
OBSERVER
T
NIL

BUTTON
401
228
521
261
Play C-major chord
let tmp pitch\nforeach [ 60 64 67 ] [\nset pitch ? Play ]\nset pitch tmp
NIL
1
T
OBSERVER
T
NIL

BUTTON
267
229
390
262
Play C-major scale
let tmp pitch\nforeach c-major-scale\n[ set pitch ?\nplay\nwait duration\n]\nset pitch tmp
NIL
1
T
OBSERVER
T
NIL

MONITOR
24
228
252
277
C-major scale
c-major-scale
3
1

MONITOR
180
104
481
153
NIL
generate-command
3
1

TEXTBOX
113
79
399
97
---------------------------------------------

TEXTBOX
104
205
375
223
---------------------------------------------

TEXTBOX
104
289
376
307
---------------------------------------------

TEXTBOX
660
10
750
367
48	C\n49	C#\n50	D\n51	D#\n52 	E\n53	F\n54	F#/Gb\n55	G\n56	A#/Bb\n57	A\n58	A#/Bb\n59	B\n60	C\n61	C#\n62	D\n63	D#\n64 	E\n65	F\n66	F#/Gb\n67	G\n68	A#/Bb\n69	A\n70	A#/Bb\n71	B\n72	C

@#$#@#$#@
WHAT IS IT?
-----------
This model demonstrates the capabilities of the NetLogo Sound Extension. It allows modelers to experiment with different instruments.

The instrument section allows you to choose one of the 128 instruments provided by the sound extension. (For a complete list, see the Sound section of the NetLogo User Manual). After you choose an instrument, you can listen to a C-major scale or chord in that instrument, or choose a particular pitch.

Each time the model plays a sound, it writes the command used to generate the sound to the command center. You can copy and paste the command to use in your models.

The memory bank lets you store the current sound for later retrieval, allowing you to hear how different sounds will sound together.
@#$#@#$#@
default
true
0
Polygon -7566196 true true 150 5 40 250 150 205 260 250

airplane
true
0
Polygon -7566196 true true 150 0 135 15 120 60 120 105 15 165 15 195 120 180 135 240 105 270 120 285 150 270 180 285 210 270 165 240 180 180 285 195 285 165 180 105 180 60 165 15

arrow
true
0
Polygon -7566196 true true 150 0 0 150 105 150 105 293 195 293 195 150 300 150

box
false
0
Polygon -7566196 true true 150 285 285 225 285 75 150 135
Polygon -7566196 true true 150 135 15 75 150 15 285 75
Polygon -7566196 true true 15 75 15 225 150 285 150 135
Line -16777216 false 150 285 150 135
Line -16777216 false 150 135 15 75
Line -16777216 false 150 135 285 75

bug
true
0
Circle -7566196 true true 96 182 108
Circle -7566196 true true 110 127 80
Circle -7566196 true true 110 75 80
Line -7566196 true 150 100 80 30
Line -7566196 true 150 100 220 30

butterfly
true
0
Polygon -7566196 true true 150 165 209 199 225 225 225 255 195 270 165 255 150 240
Polygon -7566196 true true 150 165 89 198 75 225 75 255 105 270 135 255 150 240
Polygon -7566196 true true 139 148 100 105 55 90 25 90 10 105 10 135 25 180 40 195 85 194 139 163
Polygon -7566196 true true 162 150 200 105 245 90 275 90 290 105 290 135 275 180 260 195 215 195 162 165
Polygon -16777216 true false 150 255 135 225 120 150 135 120 150 105 165 120 180 150 165 225
Circle -16777216 true false 135 90 30
Line -16777216 false 150 105 195 60
Line -16777216 false 150 105 105 60

car
false
0
Polygon -7566196 true true 300 180 279 164 261 144 240 135 226 132 213 106 203 84 185 63 159 50 135 50 75 60 0 150 0 165 0 225 300 225 300 180
Circle -16777216 true false 180 180 90
Circle -16777216 true false 30 180 90
Polygon -16777216 true false 162 80 132 78 134 135 209 135 194 105 189 96 180 89
Circle -7566196 true true 47 195 58
Circle -7566196 true true 195 195 58

circle
false
0
Circle -7566196 true true 30 30 240

circle 2
false
0
Circle -7566196 true true 16 16 270
Circle -16777216 true false 46 46 210

cow
false
0
Polygon -7566196 true true 200 193 197 249 179 249 177 196 166 187 140 189 93 191 78 179 72 211 49 209 48 181 37 149 25 120 25 89 45 72 103 84 179 75 198 76 252 64 272 81 293 103 285 121 255 121 242 118 224 167
Polygon -7566196 true true 73 210 86 251 62 249 48 208
Polygon -7566196 true true 25 114 16 195 9 204 23 213 25 200 39 123

face happy
false
0
Circle -7566196 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 255 90 239 62 213 47 191 67 179 90 203 109 218 150 225 192 218 210 203 227 181 251 194 236 217 212 240

face neutral
false
0
Circle -7566196 true true 8 7 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Rectangle -16777216 true false 60 195 240 225

face sad
false
0
Circle -7566196 true true 8 8 285
Circle -16777216 true false 60 75 60
Circle -16777216 true false 180 75 60
Polygon -16777216 true false 150 168 90 184 62 210 47 232 67 244 90 220 109 205 150 198 192 205 210 220 227 242 251 229 236 206 212 183

fish
false
0
Polygon -1 true false 44 131 21 87 15 86 0 120 15 150 0 180 13 214 20 212 45 166
Polygon -1 true false 135 195 119 235 95 218 76 210 46 204 60 165
Polygon -1 true false 75 45 83 77 71 103 86 114 166 78 135 60
Polygon -7566196 true true 30 136 151 77 226 81 280 119 292 146 292 160 287 170 270 195 195 210 151 212 30 166
Circle -16777216 true false 215 106 30

flag
false
0
Rectangle -7566196 true true 60 15 75 300
Polygon -7566196 true true 90 150 270 90 90 30
Line -7566196 true 75 135 90 135
Line -7566196 true 75 45 90 45

flower
false
0
Polygon -11352576 true false 135 120 165 165 180 210 180 240 150 300 165 300 195 240 195 195 165 135
Circle -7566196 true true 85 132 38
Circle -7566196 true true 130 147 38
Circle -7566196 true true 192 85 38
Circle -7566196 true true 85 40 38
Circle -7566196 true true 177 40 38
Circle -7566196 true true 177 132 38
Circle -7566196 true true 70 85 38
Circle -7566196 true true 130 25 38
Circle -7566196 true true 96 51 108
Circle -16777216 true false 113 68 74
Polygon -11352576 true false 189 233 219 188 249 173 279 188 234 218
Polygon -11352576 true false 180 255 150 210 105 210 75 240 135 240

house
false
0
Rectangle -7566196 true true 45 120 255 285
Rectangle -16777216 true false 120 210 180 285
Polygon -7566196 true true 15 120 150 15 285 120
Line -16777216 false 30 120 270 120

leaf
false
0
Polygon -7566196 true true 150 210 135 195 120 210 60 210 30 195 60 180 60 165 15 135 30 120 15 105 40 104 45 90 60 90 90 105 105 120 120 120 105 60 120 60 135 30 150 15 165 30 180 60 195 60 180 120 195 120 210 105 240 90 255 90 263 104 285 105 270 120 285 135 240 165 240 180 270 195 240 210 180 210 165 195
Polygon -7566196 true true 135 195 135 240 120 255 105 255 105 285 135 285 165 240 165 195

line
true
0
Line -7566196 true 150 0 150 300

pentagon
false
0
Polygon -7566196 true true 150 15 15 120 60 285 240 285 285 120

person
false
0
Circle -7566196 true true 110 5 80
Polygon -7566196 true true 105 90 120 195 90 285 105 300 135 300 150 225 165 300 195 300 210 285 180 195 195 90
Rectangle -7566196 true true 127 79 172 94
Polygon -7566196 true true 195 90 240 150 225 180 165 105
Polygon -7566196 true true 105 90 60 150 75 180 135 105

plant
false
0
Rectangle -7566196 true true 135 90 165 300
Polygon -7566196 true true 135 255 90 210 45 195 75 255 135 285
Polygon -7566196 true true 165 255 210 210 255 195 225 255 165 285
Polygon -7566196 true true 135 180 90 135 45 120 75 180 135 210
Polygon -7566196 true true 165 180 165 210 225 180 255 120 210 135
Polygon -7566196 true true 135 105 90 60 45 45 75 105 135 135
Polygon -7566196 true true 165 105 165 135 225 105 255 45 210 60
Polygon -7566196 true true 135 90 120 45 150 15 180 45 165 90

square
false
0
Rectangle -7566196 true true 30 30 270 270

square 2
false
0
Rectangle -7566196 true true 30 30 270 270
Rectangle -16777216 true false 60 60 240 240

star
false
0
Polygon -7566196 true true 60 270 150 0 240 270 15 105 285 105
Polygon -7566196 true true 75 120 105 210 195 210 225 120 150 75

target
false
0
Circle -7566196 true true 0 0 300
Circle -16777216 true false 30 30 240
Circle -7566196 true true 60 60 180
Circle -16777216 true false 90 90 120
Circle -7566196 true true 120 120 60

tree
false
0
Circle -7566196 true true 118 3 94
Rectangle -6524078 true false 120 195 180 300
Circle -7566196 true true 65 21 108
Circle -7566196 true true 116 41 127
Circle -7566196 true true 45 90 120
Circle -7566196 true true 104 74 152

triangle
false
0
Polygon -7566196 true true 150 30 15 255 285 255

triangle 2
false
0
Polygon -7566196 true true 150 30 15 255 285 255
Polygon -16777216 true false 151 99 225 223 75 224

truck
false
0
Rectangle -7566196 true true 4 45 195 187
Polygon -7566196 true true 296 193 296 150 259 134 244 104 208 104 207 194
Rectangle -1 true false 195 60 195 105
Polygon -16777216 true false 238 112 252 141 219 141 218 112
Circle -16777216 true false 234 174 42
Rectangle -7566196 true true 181 185 214 194
Circle -16777216 true false 144 174 42
Circle -16777216 true false 24 174 42
Circle -7566196 false true 24 174 42
Circle -7566196 false true 144 174 42
Circle -7566196 false true 234 174 42

turtle
true
0
Polygon -11352576 true false 215 204 240 233 246 254 228 266 215 252 193 210
Polygon -11352576 true false 195 90 225 75 245 75 260 89 269 108 261 124 240 105 225 105 210 105
Polygon -11352576 true false 105 90 75 75 55 75 40 89 31 108 39 124 60 105 75 105 90 105
Polygon -11352576 true false 132 85 134 64 107 51 108 17 150 2 192 18 192 52 169 65 172 87
Polygon -11352576 true false 85 204 60 233 54 254 72 266 85 252 107 210
Polygon -7566196 true true 119 75 179 75 209 101 224 135 220 225 175 261 128 261 81 224 74 135 88 99

wheel
false
0
Circle -7566196 true true 3 3 294
Circle -16777216 true false 30 30 240
Line -7566196 true 150 285 150 15
Line -7566196 true 15 150 285 150
Circle -7566196 true true 120 120 60
Line -7566196 true 216 40 79 269
Line -7566196 true 40 84 269 221
Line -7566196 true 40 216 269 79
Line -7566196 true 84 40 221 269

x
false
0
Polygon -7566196 true true 270 75 225 30 30 225 75 270
Polygon -7566196 true true 30 75 75 30 270 225 225 270

@#$#@#$#@
NetLogo 2.1beta4
@#$#@#$#@
@#$#@#$#@
@#$#@#$#@
